/*
 * Decompiled with CFR 0.152.
 */
package appeng.helpers.iface;

import appeng.api.config.Actionable;
import appeng.api.networking.security.IActionSource;
import appeng.api.stacks.AEFluidKey;
import appeng.api.stacks.AEItemKey;
import appeng.api.stacks.AEKey;
import appeng.api.storage.IStorageMonitorableAccessor;
import appeng.api.storage.MEStorage;
import appeng.capabilities.Capabilities;
import appeng.me.storage.ExternalStorageFacade;
import it.unimi.dsi.fastutil.objects.Object2LongMap;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.EmptyFluidHandler;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.EmptyHandler;

public interface IInterfaceTarget {
    @Nullable
    public static IInterfaceTarget get(Level l, BlockPos pos, @Nullable BlockEntity be, Direction side, IActionSource src) {
        if (be == null) {
            return null;
        }
        IStorageMonitorableAccessor accessor = (IStorageMonitorableAccessor)be.getCapability(Capabilities.STORAGE_MONITORABLE_ACCESSOR, side).orElse(null);
        if (accessor != null) {
            return IInterfaceTarget.wrapStorageMonitorable(accessor, src);
        }
        LazyOptional itemHandler = be.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, side);
        LazyOptional fluidHandler = be.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, side);
        if (itemHandler.isPresent() || fluidHandler.isPresent()) {
            return IInterfaceTarget.wrapHandlers((IItemHandler)itemHandler.orElse((Object)EmptyHandler.INSTANCE), (IFluidHandler)fluidHandler.orElse((Object)EmptyFluidHandler.INSTANCE), src);
        }
        return null;
    }

    private static IInterfaceTarget wrapStorageMonitorable(IStorageMonitorableAccessor accessor, final IActionSource src) {
        final MEStorage storage = accessor.getInventory(src);
        if (storage == null) {
            return null;
        }
        return new IInterfaceTarget(){

            @Override
            public long insert(AEKey what, long amount, Actionable type) {
                return storage.insert(what, amount, type, src);
            }

            @Override
            public boolean containsPatternInput(Set<AEKey> patternInputs) {
                for (Object2LongMap.Entry<AEKey> stack : storage.getAvailableStacks()) {
                    if (!patternInputs.contains(((AEKey)stack.getKey()).dropSecondary())) continue;
                    return true;
                }
                return false;
            }
        };
    }

    private static IInterfaceTarget wrapHandlers(IItemHandler itemHandler, IFluidHandler fluidHandler, final IActionSource src) {
        final ExternalStorageFacade itemAdapter = ExternalStorageFacade.of(itemHandler);
        final ExternalStorageFacade fluidAdapter = ExternalStorageFacade.of(fluidHandler);
        return new IInterfaceTarget(){

            @Override
            public long insert(AEKey what, long amount, Actionable type) {
                if (what instanceof AEItemKey) {
                    AEItemKey itemKey = (AEItemKey)what;
                    return itemAdapter.insert(itemKey, amount, type, src);
                }
                if (what instanceof AEFluidKey) {
                    AEFluidKey fluidKey = (AEFluidKey)what;
                    return fluidAdapter.insert(fluidKey, amount, type, src);
                }
                return 0L;
            }

            @Override
            public boolean containsPatternInput(Set<AEKey> patternInputs) {
                return itemAdapter.containsAnyFuzzy(patternInputs) || fluidAdapter.containsAnyFuzzy(patternInputs);
            }
        };
    }

    public long insert(AEKey var1, long var2, Actionable var4);

    public boolean containsPatternInput(Set<AEKey> var1);
}

