/*
 * Decompiled with CFR 0.152.
 */
package appeng.helpers.externalstorage;

import appeng.api.config.Actionable;
import appeng.api.stacks.AEFluidKey;
import appeng.api.stacks.AEKey;
import appeng.api.stacks.AEKeyType;
import appeng.helpers.externalstorage.GenericStackInv;
import appeng.me.helpers.BaseActionSource;
import com.google.common.primitives.Ints;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import org.jetbrains.annotations.NotNull;

public class GenericStackFluidStorage
implements IFluidHandler {
    private final GenericStackInv inv;

    public GenericStackFluidStorage(GenericStackInv inv) {
        this.inv = inv;
    }

    public int getTanks() {
        return this.inv.size();
    }

    @NotNull
    public FluidStack getFluidInTank(int tank) {
        AEKey aEKey = this.inv.getKey(tank);
        if (aEKey instanceof AEFluidKey) {
            AEFluidKey what = (AEFluidKey)aEKey;
            int amount = Ints.saturatedCast((long)this.inv.getAmount(tank));
            return what.toStack(amount);
        }
        return FluidStack.EMPTY;
    }

    public int getTankCapacity(int tank) {
        return Ints.saturatedCast((long)this.inv.getCapacity(AEKeyType.fluids()));
    }

    public boolean isFluidValid(int tank, @NotNull FluidStack stack) {
        AEFluidKey what = AEFluidKey.of(stack);
        return what == null || this.inv.isAllowed(what);
    }

    public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
        AEFluidKey what = AEFluidKey.of(resource);
        if (what == null) {
            return 0;
        }
        return (int)this.inv.insert(what, resource.getAmount(), Actionable.of(action), new BaseActionSource());
    }

    @NotNull
    public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
        AEFluidKey what = AEFluidKey.of(resource);
        if (what == null) {
            return FluidStack.EMPTY;
        }
        return this.extract(what, resource.getAmount(), action);
    }

    @NotNull
    public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
        for (int i = 0; i < this.inv.size(); ++i) {
            AEKey what = this.inv.getKey(i);
            AEKey aEKey = this.inv.getKey(i);
            if (!(aEKey instanceof AEFluidKey)) continue;
            AEFluidKey fluidKey = (AEFluidKey)aEKey;
            return this.extract(fluidKey, maxDrain, action);
        }
        return FluidStack.EMPTY;
    }

    private FluidStack extract(AEFluidKey what, int amount, IFluidHandler.FluidAction action) {
        int extracted = (int)this.inv.extract(what, amount, Actionable.of(action), new BaseActionSource());
        if (extracted > 0) {
            return what.toStack(extracted);
        }
        return FluidStack.EMPTY;
    }
}

