/*
 * Decompiled with CFR 0.152.
 */
package appeng.blockentity.spatial;

import appeng.api.networking.GridFlags;
import appeng.api.networking.IGridMultiblock;
import appeng.api.networking.IGridNode;
import appeng.api.networking.IGridNodeListener;
import appeng.blockentity.grid.AENetworkBlockEntity;
import appeng.me.cluster.IAEMultiBlock;
import appeng.me.cluster.implementations.SpatialPylonCalculator;
import appeng.me.cluster.implementations.SpatialPylonCluster;
import appeng.util.iterators.ChainedIterator;
import com.google.common.collect.Iterators;
import java.util.EnumSet;
import java.util.Iterator;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.client.model.data.ModelDataMap;
import net.minecraftforge.client.model.data.ModelProperty;

public class SpatialPylonBlockEntity
extends AENetworkBlockEntity
implements IAEMultiBlock<SpatialPylonCluster> {
    public static final ModelProperty<Integer> STATE = new ModelProperty(value -> (value & 0xFFFFFFC0) == 0);
    public static final int DISPLAY_END_MIN = 1;
    public static final int DISPLAY_END_MAX = 2;
    public static final int DISPLAY_MIDDLE = 3;
    public static final int DISPLAY_X = 4;
    public static final int DISPLAY_Y = 8;
    public static final int DISPLAY_Z = 12;
    public static final int MB_STATUS = 15;
    public static final int DISPLAY_ENABLED = 16;
    public static final int DISPLAY_POWERED_ENABLED = 32;
    public static final int NET_STATUS = 48;
    private final SpatialPylonCalculator calc = new SpatialPylonCalculator(this);
    private int displayBits = 0;
    private SpatialPylonCluster cluster;

    public SpatialPylonBlockEntity(BlockEntityType<?> blockEntityType, BlockPos pos, BlockState blockState) {
        super(blockEntityType, pos, blockState);
        this.getMainNode().setFlags(GridFlags.REQUIRE_CHANNEL, GridFlags.MULTIBLOCK).setIdlePowerUsage(0.5).addService(IGridMultiblock.class, this::getMultiblockNodes);
    }

    @Override
    public void onChunkUnloaded() {
        this.disconnect(false);
        super.onChunkUnloaded();
    }

    @Override
    public void onReady() {
        super.onReady();
        Level level = this.f_58857_;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            this.calc.calculateMultiblock(serverLevel, this.f_58858_);
        }
    }

    @Override
    public void m_7651_() {
        super.m_7651_();
        this.disconnect(false);
    }

    public void neighborChanged(BlockPos changedPos) {
        Level level = this.f_58857_;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            this.calc.updateMultiblockAfterNeighborUpdate(serverLevel, this.f_58858_, changedPos);
        }
    }

    @Override
    public void disconnect(boolean b) {
        if (this.cluster != null) {
            this.cluster.destroy();
            this.updateStatus(null);
        }
    }

    @Override
    public SpatialPylonCluster getCluster() {
        return this.cluster;
    }

    @Override
    public boolean isValid() {
        return true;
    }

    public void updateStatus(SpatialPylonCluster c) {
        if (this.m_58901_()) {
            return;
        }
        this.cluster = c;
        this.getMainNode().setExposedOnSides(c == null ? EnumSet.noneOf(Direction.class) : EnumSet.allOf(Direction.class));
        this.recalculateDisplay();
    }

    public void recalculateDisplay() {
        int oldBits = this.displayBits;
        this.displayBits = 0;
        if (this.cluster != null) {
            this.displayBits = this.cluster.getBoundsMin().equals((Object)this.f_58858_) ? 1 : (this.cluster.getBoundsMax().equals((Object)this.f_58858_) ? 2 : 3);
            switch (this.cluster.getCurrentAxis()) {
                case X: {
                    this.displayBits |= 4;
                    break;
                }
                case Y: {
                    this.displayBits |= 8;
                    break;
                }
                case Z: {
                    this.displayBits |= 0xC;
                    break;
                }
                default: {
                    this.displayBits = 0;
                }
            }
            if (this.getMainNode().isPowered()) {
                this.displayBits |= 0x20;
            }
            if (this.cluster.isValid() && this.getMainNode().isActive()) {
                this.displayBits |= 0x10;
            }
        }
        if (oldBits != this.displayBits) {
            this.markForUpdate();
        }
    }

    @Override
    public boolean canBeRotated() {
        return false;
    }

    @Override
    protected boolean readFromStream(FriendlyByteBuf data) {
        boolean c = super.readFromStream(data);
        int old = this.displayBits;
        this.displayBits = data.readByte();
        return old != this.displayBits || c;
    }

    @Override
    protected void writeToStream(FriendlyByteBuf data) {
        super.writeToStream(data);
        data.writeByte(this.displayBits);
    }

    @Override
    public void onMainNodeStateChanged(IGridNodeListener.State reason) {
        this.recalculateDisplay();
    }

    public int getDisplayBits() {
        return this.displayBits;
    }

    @Override
    public IModelData getModelData() {
        return new ModelDataMap.Builder().withInitial(STATE, (Object)this.getDisplayBits()).build();
    }

    private Iterator<IGridNode> getMultiblockNodes() {
        if (this.getCluster() == null) {
            return new ChainedIterator<IGridNode>(new IGridNode[0]);
        }
        return Iterators.transform(this.getCluster().getBlockEntities(), AENetworkBlockEntity::getGridNode);
    }
}

