/*
 * Decompiled with CFR 0.152.
 */
package appeng.blockentity.misc;

import appeng.api.config.SecurityPermissions;
import appeng.api.config.Settings;
import appeng.api.config.SortDir;
import appeng.api.config.SortOrder;
import appeng.api.config.ViewItems;
import appeng.api.features.IPlayerRegistry;
import appeng.api.features.Locatables;
import appeng.api.implementations.blockentities.IColorableBlockEntity;
import appeng.api.inventories.InternalInventory;
import appeng.api.networking.GridFlags;
import appeng.api.networking.IGridNodeListener;
import appeng.api.networking.events.GridSecurityChange;
import appeng.api.networking.security.ISecurityProvider;
import appeng.api.stacks.AEItemKey;
import appeng.api.storage.ITerminalHost;
import appeng.api.storage.MEStorage;
import appeng.api.util.AECableType;
import appeng.api.util.AEColor;
import appeng.api.util.IConfigManager;
import appeng.blockentity.grid.AENetworkBlockEntity;
import appeng.items.tools.BiometricCardItem;
import appeng.me.storage.SecurityStationInventory;
import appeng.menu.ISubMenu;
import appeng.menu.MenuOpener;
import appeng.menu.implementations.SecurityStationMenu;
import appeng.menu.locator.MenuLocators;
import appeng.util.ConfigManager;
import appeng.util.inv.AppEngInternalInventory;
import appeng.util.inv.InternalInventoryHost;
import com.mojang.authlib.GameProfile;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class SecurityStationBlockEntity
extends AENetworkBlockEntity
implements ITerminalHost,
InternalInventoryHost,
ISecurityProvider,
IColorableBlockEntity {
    private static int difference = 0;
    private final AppEngInternalInventory configSlot = new AppEngInternalInventory(this, 1);
    private final IConfigManager cm = new ConfigManager();
    private final SecurityStationInventory inventory = new SecurityStationInventory(this);
    private long securityKey;
    private AEColor paintedColor = AEColor.TRANSPARENT;
    private boolean isActive = false;

    public SecurityStationBlockEntity(BlockEntityType<?> blockEntityType, BlockPos pos, BlockState blockState) {
        super(blockEntityType, pos, blockState);
        this.getMainNode().setFlags(GridFlags.REQUIRE_CHANNEL).setIdlePowerUsage(2.0).addService(ISecurityProvider.class, this);
        this.securityKey = System.currentTimeMillis() * 10L + (long)(++difference);
        if (difference > 10) {
            difference = 0;
        }
        this.cm.registerSetting(Settings.SORT_BY, SortOrder.NAME);
        this.cm.registerSetting(Settings.VIEW_MODE, ViewItems.ALL);
        this.cm.registerSetting(Settings.SORT_DIRECTION, SortDir.ASCENDING);
    }

    @Override
    public void onChangeInventory(InternalInventory inv, int slot) {
    }

    @Override
    public void addAdditionalDrops(Level level, BlockPos pos, List<ItemStack> drops) {
        if (!this.getConfigSlot().isEmpty()) {
            drops.add(this.getConfigSlot().getStackInSlot(0));
        }
        for (AEItemKey key : this.inventory.getStoredItems()) {
            drops.add(key.toStack());
        }
    }

    @Override
    protected boolean readFromStream(FriendlyByteBuf data) {
        boolean c = super.readFromStream(data);
        boolean wasActive = this.isActive;
        this.isActive = data.readBoolean();
        AEColor oldPaintedColor = this.paintedColor;
        this.paintedColor = AEColor.values()[data.readByte()];
        return oldPaintedColor != this.paintedColor || wasActive != this.isActive || c;
    }

    @Override
    protected void writeToStream(FriendlyByteBuf data) {
        super.writeToStream(data);
        data.writeBoolean(this.getMainNode().isActive());
        data.writeByte(this.paintedColor.ordinal());
    }

    @Override
    public void m_183515_(CompoundTag data) {
        super.m_183515_(data);
        this.cm.writeToNBT(data);
        data.m_128344_("paintedColor", (byte)this.paintedColor.ordinal());
        data.m_128356_("securityKey", this.securityKey);
        this.getConfigSlot().writeToNBT(data, "config");
        ListTag storedItems = new ListTag();
        for (AEItemKey key : this.inventory.getStoredItems()) {
            storedItems.add((Object)key.toTag());
        }
        data.m_128365_("cards", (Tag)storedItems);
    }

    @Override
    public void loadTag(CompoundTag data) {
        super.loadTag(data);
        this.cm.readFromNBT(data);
        if (data.m_128441_("paintedColor")) {
            this.paintedColor = AEColor.values()[data.m_128445_("paintedColor")];
        }
        this.securityKey = data.m_128454_("securityKey");
        this.getConfigSlot().readFromNBT(data, "config");
        ListTag cards = data.m_128437_("cards", 10);
        for (Tag keyTag : cards) {
            AEItemKey key = AEItemKey.fromTag((CompoundTag)keyTag);
            if (key == null) continue;
            this.inventory.getStoredItems().add(key);
        }
    }

    public void inventoryChanged() {
        this.saveChanges();
        this.getMainNode().ifPresent(grid -> grid.postEvent(new GridSecurityChange()));
    }

    @Override
    public void onMainNodeStateChanged(IGridNodeListener.State reason) {
        this.markForUpdate();
    }

    @Override
    public AECableType getCableConnectionType(Direction dir) {
        return AECableType.SMART;
    }

    @Override
    public void onChunkUnloaded() {
        super.onChunkUnloaded();
        Locatables.securityStations().unregister(this.m_58904_(), this.securityKey);
        this.isActive = false;
    }

    @Override
    public void onReady() {
        super.onReady();
        if (!this.isClientSide()) {
            this.isActive = true;
            Locatables.securityStations().register(this.m_58904_(), this.securityKey, this);
        }
    }

    @Override
    public void m_7651_() {
        super.m_7651_();
        Locatables.securityStations().unregister(this.m_58904_(), this.securityKey);
        this.isActive = false;
    }

    public boolean isActive() {
        if (this.f_58857_ != null && !this.f_58857_.f_46443_) {
            return this.isPowered();
        }
        return this.isActive;
    }

    @Override
    public MEStorage getInventory() {
        return this.inventory;
    }

    public boolean isPowered() {
        return this.getMainNode().isActive();
    }

    @Override
    public IConfigManager getConfigManager() {
        return this.cm;
    }

    @Override
    public long getSecurityKey() {
        return this.securityKey;
    }

    @Override
    public void readPermissions(Map<Integer, EnumSet<SecurityPermissions>> playerPerms) {
        IPlayerRegistry pr = IPlayerRegistry.getMapping(this.m_58904_());
        if (pr == null) {
            return;
        }
        for (AEItemKey key : this.inventory.getStoredItems()) {
            Item item = key.getItem();
            if (!(item instanceof BiometricCardItem)) continue;
            BiometricCardItem bc = (BiometricCardItem)item;
            int playerId = -1;
            GameProfile profile = bc.getProfile(key);
            if (profile != null) {
                playerId = pr.getPlayerId(profile);
            }
            EnumSet<SecurityPermissions> permissions = bc.getPermissions(key.getTag());
            playerPerms.put(playerId, permissions);
        }
        playerPerms.put(this.getMainNode().getNode().getOwningPlayerId(), EnumSet.allOf(SecurityPermissions.class));
    }

    @Override
    public boolean isSecurityEnabled() {
        return this.isActive && this.getMainNode().isActive();
    }

    @Override
    public int getOwner() {
        return this.getMainNode().getNode().getOwningPlayerId();
    }

    @Override
    public AEColor getColor() {
        return this.paintedColor;
    }

    @Override
    public boolean recolourBlock(Direction side, AEColor newPaintedColor, Player who) {
        if (this.paintedColor == newPaintedColor) {
            return false;
        }
        this.paintedColor = newPaintedColor;
        this.saveChanges();
        this.markForUpdate();
        return true;
    }

    public AppEngInternalInventory getConfigSlot() {
        return this.configSlot;
    }

    @Override
    public void returnToMainMenu(Player player, ISubMenu subMenu) {
        this.openMenu(player);
    }

    @Override
    public ItemStack getMainMenuIcon() {
        return new ItemStack((ItemLike)this.getItemFromBlockEntity());
    }

    public void openMenu(Player p) {
        MenuOpener.open(SecurityStationMenu.TYPE, p, MenuLocators.forBlockEntity(this));
    }
}

