/*
 * Decompiled with CFR 0.152.
 */
package appeng.api.stacks;

import appeng.api.stacks.AEKey;
import appeng.api.stacks.AEKeyType;
import appeng.api.storage.AEKeyFilter;
import appeng.core.AELog;
import java.util.Objects;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.Nullable;

public final class AEItemKey
extends AEKey {
    private final Item item;
    @Nullable
    private final CompoundTag tag;
    private final int hashCode;

    private AEItemKey(Item item, @Nullable CompoundTag tag) {
        this.item = item;
        this.tag = tag;
        this.hashCode = Objects.hash(item, tag);
    }

    @Nullable
    public static AEItemKey of(ItemStack stack) {
        if (stack.m_41619_()) {
            return null;
        }
        return AEItemKey.of((ItemLike)stack.m_41720_(), stack.m_41783_());
    }

    public static boolean matches(AEKey what, ItemStack itemStack) {
        AEItemKey itemKey;
        return what instanceof AEItemKey && (itemKey = (AEItemKey)what).matches(itemStack);
    }

    public static boolean is(AEKey what) {
        return what instanceof AEItemKey;
    }

    public static AEKeyFilter filter() {
        return AEItemKey::is;
    }

    @Override
    public AEKeyType getType() {
        return AEKeyType.items();
    }

    @Override
    public AEItemKey dropSecondary() {
        return AEItemKey.of((ItemLike)this.item, null);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AEItemKey aeItemKey = (AEItemKey)o;
        return this.hashCode == aeItemKey.hashCode && this.item == aeItemKey.item && Objects.equals(this.tag, aeItemKey.tag);
    }

    public int hashCode() {
        return this.hashCode;
    }

    public static AEItemKey of(ItemLike item) {
        return AEItemKey.of(item, null);
    }

    public static AEItemKey of(ItemLike item, @Nullable CompoundTag tag) {
        return new AEItemKey(item.m_5456_(), tag != null ? tag.m_6426_() : null);
    }

    public boolean matches(ItemStack stack) {
        return !stack.m_41619_() && stack.m_150930_(this.item) && Objects.equals(stack.m_41783_(), this.tag);
    }

    public ItemStack toStack() {
        return this.toStack(1);
    }

    public ItemStack toStack(int count) {
        if (count <= 0) {
            return ItemStack.f_41583_;
        }
        ItemStack result = new ItemStack((ItemLike)this.item);
        result.m_41751_(this.copyTag());
        result.m_41764_(count);
        return result;
    }

    @Nullable
    public CompoundTag copyTag() {
        return this.tag != null ? this.tag.m_6426_() : null;
    }

    public Item getItem() {
        return this.item;
    }

    @Nullable
    public static AEItemKey fromTag(CompoundTag tag) {
        try {
            Item item = (Item)Registry.f_122827_.m_6612_(new ResourceLocation(tag.m_128461_("id"))).orElseThrow(() -> new IllegalArgumentException("Unknown item id."));
            CompoundTag extraTag = tag.m_128441_("tag") ? tag.m_128469_("tag") : null;
            return AEItemKey.of((ItemLike)item, extraTag);
        }
        catch (Exception e) {
            AELog.debug("Tried to load an invalid item key from NBT: %s", tag, e);
            return null;
        }
    }

    @Override
    public CompoundTag toTag() {
        CompoundTag result = new CompoundTag();
        result.m_128359_("id", Registry.f_122827_.m_7981_((Object)this.item).toString());
        if (this.tag != null) {
            result.m_128365_("tag", (Tag)this.tag.m_6426_());
        }
        return result;
    }

    @Override
    public Object getPrimaryKey() {
        return this.item;
    }

    @Override
    public int getFuzzySearchValue() {
        return this.tag == null ? 0 : this.tag.m_128451_("Damage");
    }

    @Override
    public int getFuzzySearchMaxValue() {
        return this.item.m_41462_();
    }

    @Override
    public String getModId() {
        return Registry.f_122827_.m_7981_((Object)this.item).m_135827_();
    }

    @Nullable
    public CompoundTag getTag() {
        return this.tag;
    }

    public boolean hasTag() {
        return this.tag != null;
    }

    @Override
    public ItemStack wrapForDisplayOrFilter() {
        return this.toStack();
    }

    @Override
    public ItemStack wrap(int amount) {
        return this.toStack(amount);
    }

    @Override
    public Component getDisplayName() {
        return this.toStack().m_41786_();
    }

    public boolean isDamaged() {
        return this.tag != null && this.tag.m_128451_("Damage") > 0;
    }

    @Override
    public void writeToPacket(FriendlyByteBuf data) {
        data.m_130130_(Item.m_41393_((Item)this.item));
        CompoundTag compoundTag = null;
        if (this.item.m_41465_() || this.item.m_41468_()) {
            compoundTag = this.tag;
        }
        data.m_130079_(compoundTag);
    }

    public static AEItemKey fromPacket(FriendlyByteBuf data) {
        int i = data.m_130242_();
        Item item = Item.m_41445_((int)i);
        CompoundTag tag = data.m_130260_();
        return new AEItemKey(item, tag);
    }

    public String toString() {
        ResourceLocation id = Registry.f_122827_.m_7981_((Object)this.item);
        String idString = id != Registry.f_122827_.m_122315_() ? id.toString() : this.item.getClass().getName() + "(unregistered)";
        return this.tag == null ? idString : idString + " (+tag)";
    }
}

