/*
 * Decompiled with CFR 0.152.
 */
package com.jozufozu.flywheel.mixin;

import com.google.common.collect.Lists;
import com.jozufozu.flywheel.backend.Backend;
import com.jozufozu.flywheel.backend.instancing.InstancedRenderRegistry;
import java.util.ArrayList;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.world.entity.Entity;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Group;
import org.spongepowered.asm.mixin.injection.Redirect;

@Mixin(value={LevelRenderer.class})
public class CancelEntityRenderMixin {
    @Redirect(method={"renderLevel"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/multiplayer/ClientLevel;entitiesForRendering()Ljava/lang/Iterable;"))
    @Group(name="entityFilter", min=1, max=1)
    private Iterable<Entity> filterEntities(ClientLevel world) {
        Iterable entities = world.m_104735_();
        if (Backend.isOn()) {
            ArrayList filtered = Lists.newArrayList((Iterable)entities);
            filtered.removeIf(InstancedRenderRegistry::shouldSkipRender);
            return filtered;
        }
        return entities;
    }
}

