/*
 * Decompiled with CFR 0.152.
 */
package com.jozufozu.flywheel.backend.instancing.batching;

import com.jozufozu.flywheel.api.MaterialGroup;
import com.jozufozu.flywheel.backend.RenderLayer;
import com.jozufozu.flywheel.backend.instancing.BatchDrawingTracker;
import com.jozufozu.flywheel.backend.instancing.Engine;
import com.jozufozu.flywheel.backend.instancing.TaskEngine;
import com.jozufozu.flywheel.backend.instancing.batching.BatchedMaterialGroup;
import com.jozufozu.flywheel.event.RenderLayerEvent;
import com.mojang.blaze3d.platform.Lighting;
import com.mojang.math.Matrix4f;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Camera;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;

public class BatchingEngine
implements Engine {
    private final Map<RenderLayer, Map<RenderType, BatchedMaterialGroup>> layers;
    private final BatchDrawingTracker batchTracker = new BatchDrawingTracker();

    public BatchingEngine() {
        this.layers = new EnumMap<RenderLayer, Map<RenderType, BatchedMaterialGroup>>(RenderLayer.class);
        for (RenderLayer value : RenderLayer.values()) {
            this.layers.put(value, new HashMap());
        }
    }

    @Override
    public MaterialGroup state(RenderLayer layer, RenderType state) {
        return this.layers.get((Object)layer).computeIfAbsent(state, BatchedMaterialGroup::new);
    }

    @Override
    public Vec3i getOriginCoordinate() {
        return BlockPos.f_121853_;
    }

    @Override
    public void render(TaskEngine taskEngine, RenderLayerEvent event) {
        Map<RenderType, BatchedMaterialGroup> groups = this.layers.get((Object)event.getLayer());
        for (BatchedMaterialGroup group : groups.values()) {
            group.render(event.stack, this.batchTracker, taskEngine);
        }
        Matrix4f mat = new Matrix4f();
        mat.m_27624_();
        if (event.getWorld().m_104583_().m_108885_()) {
            Lighting.m_84925_((Matrix4f)mat);
        } else {
            Lighting.m_84928_((Matrix4f)mat);
        }
        taskEngine.syncPoint();
        this.batchTracker.endBatch();
    }

    @Override
    public void delete() {
    }

    @Override
    public void beginFrame(Camera info) {
    }
}

