/*
 * Decompiled with CFR 0.152.
 */
package com.jozufozu.flywheel.backend.gl.versioned;

import com.jozufozu.flywheel.backend.gl.versioned.BufferStorage;
import com.jozufozu.flywheel.backend.gl.versioned.GlVersioned;
import com.jozufozu.flywheel.backend.gl.versioned.InstancedArrays;
import java.nio.ByteBuffer;
import java.util.Arrays;
import net.minecraft.Util;
import org.lwjgl.PointerBuffer;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GL20C;
import org.lwjgl.opengl.GLCapabilities;
import org.lwjgl.system.APIUtil;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;

public class GlCompat {
    public final InstancedArrays instancedArrays;
    public final BufferStorage bufferStorage;
    public final boolean amd;

    public GlCompat() {
        String vendor;
        GLCapabilities caps = GL.createCapabilities();
        this.instancedArrays = GlCompat.getLatest(InstancedArrays.class, caps);
        this.bufferStorage = GlCompat.getLatest(BufferStorage.class, caps);
        this.amd = Util.m_137581_() == Util.OS.WINDOWS ? (vendor = GL20C.glGetString((int)7936)).contains("ATI") || vendor.contains("AMD") : false;
    }

    public boolean onAMDWindows() {
        return this.amd;
    }

    public boolean instancedArraysSupported() {
        return this.instancedArrays != InstancedArrays.UNSUPPORTED;
    }

    public boolean bufferStorageSupported() {
        return this.bufferStorage != BufferStorage.UNSUPPORTED;
    }

    public static <V extends Enum<V>> V getLatest(Class<V> clazz, GLCapabilities caps) {
        Enum[] constants = (Enum[])clazz.getEnumConstants();
        Enum last = constants[constants.length - 1];
        if (!((GlVersioned)((Object)last)).supported(caps)) {
            throw new IllegalStateException("");
        }
        return (V)Arrays.stream(constants).filter(it -> ((GlVersioned)((Object)it)).supported(caps)).findFirst().get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void safeShaderSource(int glId, CharSequence source) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer sourceBuffer = MemoryUtil.memUTF8((CharSequence)source, (boolean)true);
            PointerBuffer pointers = stack.mallocPointer(1);
            pointers.put(sourceBuffer);
            GL20C.nglShaderSource((int)glId, (int)1, (long)pointers.address0(), (long)0L);
            APIUtil.apiArrayFree((long)pointers.address0(), (int)1);
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }
}

