/*
 * Decompiled with CFR 0.152.
 */
package com.jozufozu.flywheel.backend;

import com.jozufozu.flywheel.backend.Backend;
import com.jozufozu.flywheel.util.Lazy;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.Optional;
import java.util.function.BooleanSupplier;
import net.minecraft.client.Minecraft;

public class OptifineHandler {
    public static final String OPTIFINE_ROOT_PACKAGE = "net.optifine";
    public static final String SHADER_PACKAGE = "net.optifine.shaders";
    private static Package optifine;
    private static OptifineHandler handler;
    private static final Lazy<BooleanSupplier> isShadowPass;
    public final boolean usingShaders;

    public OptifineHandler(boolean usingShaders) {
        this.usingShaders = usingShaders;
    }

    public static Optional<OptifineHandler> get() {
        return Optional.ofNullable(handler);
    }

    public static boolean optifineInstalled() {
        return optifine != null;
    }

    public static boolean usingShaders() {
        return OptifineHandler.get().map(OptifineHandler::isUsingShaders).orElse(false);
    }

    public static boolean isShadowPass() {
        return isShadowPass.get().getAsBoolean();
    }

    public static void init() {
        optifine = Package.getPackage(OPTIFINE_ROOT_PACKAGE);
        if (optifine == null) {
            Backend.LOGGER.info("Optifine not detected.");
        } else {
            Backend.LOGGER.info("Optifine detected.");
            OptifineHandler.refresh();
        }
    }

    public static void refresh() {
        if (optifine == null) {
            return;
        }
        boolean shadersOff = OptifineHandler.areShadersDisabledInOptifineConfigFile();
        handler = new OptifineHandler(!shadersOff);
    }

    private static boolean areShadersDisabledInOptifineConfigFile() {
        File dir = Minecraft.m_91087_().f_91069_;
        File shaderOptions = new File(dir, "optionsshaders.txt");
        boolean shadersOff = true;
        try (BufferedReader reader = new BufferedReader(new FileReader(shaderOptions));){
            shadersOff = reader.lines().anyMatch(it -> {
                String line = it.replaceAll("\\s", "");
                if (line.startsWith("shaderPack=")) {
                    String setting = line.substring("shaderPack=".length());
                    return setting.equals("OFF") || setting.equals("(internal)");
                }
                return false;
            });
        }
        catch (IOException e) {
            Backend.LOGGER.info("No shader config found.");
        }
        return shadersOff;
    }

    public boolean isUsingShaders() {
        return this.usingShaders;
    }

    static {
        isShadowPass = Lazy.of(() -> {
            try {
                Class<?> ofShaders = Class.forName("net.optifine.shaders.Shaders");
                Field field = ofShaders.getDeclaredField("isShadowPass");
                field.setAccessible(true);
                return () -> {
                    try {
                        return field.getBoolean(null);
                    }
                    catch (IllegalAccessException ignored) {
                        return false;
                    }
                };
            }
            catch (Exception ignored) {
                return () -> false;
            }
        });
    }
}

