/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.voicechat.voice.client;

import com.mojang.blaze3d.platform.InputConstants;
import de.maxhenkel.voicechat.VoicechatClient;
import de.maxhenkel.voicechat.debug.DebugReport;
import de.maxhenkel.voicechat.gui.GroupScreen;
import de.maxhenkel.voicechat.gui.JoinGroupScreen;
import de.maxhenkel.voicechat.gui.VoiceChatScreen;
import de.maxhenkel.voicechat.gui.VoiceChatSettingsScreen;
import de.maxhenkel.voicechat.intercompatibility.ClientCompatibilityManager;
import de.maxhenkel.voicechat.voice.client.ClientManager;
import de.maxhenkel.voicechat.voice.client.ClientPlayerStateManager;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.entity.player.Player;

public class KeyEvents {
    private final Minecraft minecraft = Minecraft.m_91087_();
    public static KeyMapping KEY_PTT;
    public static KeyMapping KEY_WHISPER;
    public static KeyMapping KEY_MUTE;
    public static KeyMapping KEY_DISABLE;
    public static KeyMapping KEY_HIDE_ICONS;
    public static KeyMapping KEY_VOICE_CHAT;
    public static KeyMapping KEY_VOICE_CHAT_SETTINGS;
    public static KeyMapping KEY_GROUP;
    public static KeyMapping KEY_TOGGLE_RECORDING;

    public KeyEvents() {
        ClientCompatibilityManager.INSTANCE.onHandleKeyBinds(this::handleKeybinds);
        KEY_PTT = ClientCompatibilityManager.INSTANCE.registerKeyBinding(new KeyMapping("key.push_to_talk", 280, "key.categories.voicechat"));
        KEY_WHISPER = ClientCompatibilityManager.INSTANCE.registerKeyBinding(new KeyMapping("key.whisper", InputConstants.f_84822_.m_84873_(), "key.categories.voicechat"));
        KEY_MUTE = ClientCompatibilityManager.INSTANCE.registerKeyBinding(new KeyMapping("key.mute_microphone", 77, "key.categories.voicechat"));
        KEY_DISABLE = ClientCompatibilityManager.INSTANCE.registerKeyBinding(new KeyMapping("key.disable_voice_chat", 78, "key.categories.voicechat"));
        KEY_HIDE_ICONS = ClientCompatibilityManager.INSTANCE.registerKeyBinding(new KeyMapping("key.hide_icons", 72, "key.categories.voicechat"));
        KEY_VOICE_CHAT = ClientCompatibilityManager.INSTANCE.registerKeyBinding(new KeyMapping("key.voice_chat", 86, "key.categories.voicechat"));
        KEY_VOICE_CHAT_SETTINGS = ClientCompatibilityManager.INSTANCE.registerKeyBinding(new KeyMapping("key.voice_chat_settings", InputConstants.f_84822_.m_84873_(), "key.categories.voicechat"));
        KEY_GROUP = ClientCompatibilityManager.INSTANCE.registerKeyBinding(new KeyMapping("key.voice_chat_group", 71, "key.categories.voicechat"));
        KEY_TOGGLE_RECORDING = ClientCompatibilityManager.INSTANCE.registerKeyBinding(new KeyMapping("key.voice_chat_toggle_recording", InputConstants.f_84822_.m_84873_(), "key.categories.voicechat"));
    }

    private void handleKeybinds() {
        ClientPlayerStateManager playerStateManager = ClientManager.getPlayerStateManager();
        if (KEY_VOICE_CHAT.m_90859_()) {
            if (InputConstants.m_84830_((long)this.minecraft.m_91268_().m_85439_(), (int)292)) {
                this.minecraft.f_91066_.f_92063_ = true;
                DebugReport.generateReport((Player)this.minecraft.f_91074_);
            } else {
                this.minecraft.m_91152_((Screen)new VoiceChatScreen());
            }
        }
        if (KEY_GROUP.m_90859_()) {
            if (ClientManager.getClient() != null && ClientManager.getClient().getConnection() != null && ClientManager.getClient().getConnection().getData().groupsEnabled()) {
                if (playerStateManager.isInGroup()) {
                    this.minecraft.m_91152_((Screen)new GroupScreen(playerStateManager.getGroup()));
                } else {
                    this.minecraft.m_91152_((Screen)new JoinGroupScreen());
                }
            } else {
                this.minecraft.f_91074_.m_5661_((Component)new TranslatableComponent("message.voicechat.groups_disabled"), true);
            }
        }
        if (KEY_VOICE_CHAT_SETTINGS.m_90859_()) {
            this.minecraft.m_91152_((Screen)new VoiceChatSettingsScreen());
        }
        if (KEY_PTT.m_90859_()) {
            this.checkConnected();
        }
        if (KEY_WHISPER.m_90859_()) {
            this.checkConnected();
        }
        if (KEY_MUTE.m_90859_() && this.checkConnected()) {
            playerStateManager.setMuted(!playerStateManager.isMuted());
        }
        if (KEY_DISABLE.m_90859_() && this.checkConnected()) {
            playerStateManager.setDisabled(!playerStateManager.isDisabled());
        }
        if (KEY_TOGGLE_RECORDING.m_90859_() && ClientManager.getClient() != null) {
            ClientManager.getClient().toggleRecording();
        }
        if (KEY_HIDE_ICONS.m_90859_()) {
            boolean hidden = VoicechatClient.CLIENT_CONFIG.hideIcons.get() == false;
            VoicechatClient.CLIENT_CONFIG.hideIcons.set(hidden).save();
            if (hidden) {
                this.minecraft.f_91074_.m_5661_((Component)new TranslatableComponent("message.voicechat.icons_hidden"), true);
            } else {
                this.minecraft.f_91074_.m_5661_((Component)new TranslatableComponent("message.voicechat.icons_visible"), true);
            }
        }
    }

    private boolean checkConnected() {
        if (ClientManager.getClient() == null || ClientManager.getClient().getConnection() == null || !ClientManager.getClient().getConnection().isAuthenticated()) {
            this.sendUnavailableMessage();
            return false;
        }
        return true;
    }

    private void sendUnavailableMessage() {
        this.minecraft.f_91074_.m_5661_((Component)new TranslatableComponent("message.voicechat.voice_chat_not_connected"), true);
    }
}

