/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.voicechat.audio;

import com.sonicether.soundphysics.SoundPhysics;
import de.maxhenkel.voicechat.audio.ForgeSoundManager;
import de.maxhenkel.voicechat.voice.client.ALSpeaker;
import de.maxhenkel.voicechat.voice.client.SoundManager;
import javax.annotation.Nullable;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.phys.Vec3;

public class ForgeALSpeaker
extends ALSpeaker {
    private long lastUpdate;
    private Vec3 lastPos;

    public ForgeALSpeaker(SoundManager soundManager, int sampleRate, int bufferSize) {
        super(soundManager, sampleRate, bufferSize);
    }

    @Override
    protected void setPositionSync(@Nullable Vec3 soundPos) {
        ForgeSoundManager manager;
        super.setPositionSync(soundPos);
        SoundManager soundManager = this.soundManager;
        if (soundManager instanceof ForgeSoundManager && (manager = (ForgeSoundManager)soundManager).isSoundPhysicsLoaded()) {
            this.processSoundPhysics(soundPos);
        }
    }

    private void processSoundPhysics(@Nullable Vec3 soundPos) {
        SoundManager soundManager = this.soundManager;
        if (!(soundManager instanceof ForgeSoundManager)) {
            return;
        }
        ForgeSoundManager manager = (ForgeSoundManager)soundManager;
        if (soundPos == null) {
            SoundPhysics.setDefaultEnvironment((int)this.source);
            return;
        }
        long time = System.currentTimeMillis();
        if (time - this.lastUpdate < 500L && this.lastPos != null && this.lastPos.m_82554_(soundPos) < 1.0) {
            return;
        }
        if (manager.isSoundPhysicsLoaded()) {
            SoundPhysics.setLastSoundCategoryAndName((SoundSource)SoundSource.MASTER, (String)"voicechat");
            SoundPhysics.onPlaySound((double)soundPos.m_7096_(), (double)soundPos.m_7098_(), (double)soundPos.m_7094_(), (int)this.source);
        } else {
            SoundPhysics.processSound((int)this.source, (double)soundPos.m_7096_(), (double)soundPos.m_7098_(), (double)soundPos.m_7094_(), (SoundSource)SoundSource.MASTER, (String)"voicechat");
        }
        this.lastUpdate = time;
        this.lastPos = soundPos;
    }
}

