/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.search;

import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.Collection;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import mezz.jei.config.SearchMode;
import mezz.jei.ingredients.IIngredientListElementInfo;
import mezz.jei.ingredients.IngredientFilterBackgroundBuilder;
import mezz.jei.ingredients.PrefixedSearchable;
import mezz.jei.search.CombinedSearchables;
import mezz.jei.search.IElementSearch;
import mezz.jei.search.ISearchable;
import mezz.jei.search.PrefixInfo;
import mezz.jei.search.suffixtree.GeneralizedSuffixTree;
import net.minecraft.core.NonNullList;

public class ElementSearch
implements IElementSearch {
    private final GeneralizedSuffixTree noPrefixSearchable;
    private final Map<PrefixInfo, PrefixedSearchable<GeneralizedSuffixTree>> prefixedSearchables = new IdentityHashMap<PrefixInfo, PrefixedSearchable<GeneralizedSuffixTree>>();
    private final IngredientFilterBackgroundBuilder backgroundBuilder;
    private final CombinedSearchables combinedSearchables = new CombinedSearchables();
    private final NonNullList<IIngredientListElementInfo<?>> elementInfoList = NonNullList.m_122779_();

    public ElementSearch() {
        this.noPrefixSearchable = new GeneralizedSuffixTree();
        this.backgroundBuilder = new IngredientFilterBackgroundBuilder(this.prefixedSearchables, this.elementInfoList);
        this.combinedSearchables.addSearchable(this.noPrefixSearchable);
    }

    @Override
    public void start() {
        this.backgroundBuilder.start();
    }

    @Override
    public IntSet getSearchResults(String token, PrefixInfo prefixInfo) {
        if (token.isEmpty()) {
            return IntSet.of();
        }
        ISearchable searchable = this.prefixedSearchables.get(prefixInfo);
        if (searchable != null && searchable.getMode() != SearchMode.DISABLED) {
            return searchable.search(token);
        }
        return this.combinedSearchables.search(token);
    }

    @Override
    public <V> void add(IIngredientListElementInfo<V> info) {
        int index = this.elementInfoList.size();
        this.elementInfoList.add(info);
        Collection<String> strings = PrefixInfo.NO_PREFIX.getStrings(info);
        for (String string : strings) {
            this.noPrefixSearchable.put(string, index);
        }
        for (PrefixedSearchable<GeneralizedSuffixTree> prefixedSearchable : this.prefixedSearchables.values()) {
            SearchMode searchMode = prefixedSearchable.getMode();
            if (searchMode == SearchMode.DISABLED) continue;
            Collection<String> strings2 = prefixedSearchable.getStrings(info);
            GeneralizedSuffixTree searchable = prefixedSearchable.getSearchable();
            for (String string : strings2) {
                searchable.put(string, index);
            }
        }
    }

    @Override
    public <V> IIngredientListElementInfo<V> get(int index) {
        return (IIngredientListElementInfo)this.elementInfoList.get(index);
    }

    @Override
    public <V> int indexOf(IIngredientListElementInfo<V> ingredient) {
        return this.elementInfoList.indexOf(ingredient);
    }

    @Override
    public int size() {
        return this.elementInfoList.size();
    }

    @Override
    public List<IIngredientListElementInfo<?>> getAllIngredients() {
        return Collections.unmodifiableList(this.elementInfoList);
    }

    @Override
    public void registerPrefix(PrefixInfo prefixInfo) {
        GeneralizedSuffixTree searchable = new GeneralizedSuffixTree();
        PrefixedSearchable<GeneralizedSuffixTree> prefixedSearchable = new PrefixedSearchable<GeneralizedSuffixTree>(searchable, prefixInfo);
        this.prefixedSearchables.put(prefixInfo, prefixedSearchable);
        this.combinedSearchables.addSearchable(prefixedSearchable);
    }
}

