/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.recipes;

import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import mezz.jei.api.gui.IRecipeLayoutDrawable;
import mezz.jei.api.helpers.IModIdHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.ingredients.ITypedIngredient;
import mezz.jei.api.recipe.IFocus;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.IRecipeManager;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.runtime.IIngredientManager;
import mezz.jei.gui.Focus;
import mezz.jei.gui.recipes.RecipeLayout;
import mezz.jei.recipes.FocusGroup;
import mezz.jei.recipes.RecipeManagerInternal;
import mezz.jei.util.ErrorUtil;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;

public class RecipeManager
implements IRecipeManager {
    private final RecipeManagerInternal internal;
    private final IModIdHelper modIdHelper;
    private final IIngredientManager ingredientManager;

    public RecipeManager(RecipeManagerInternal internal, IModIdHelper modIdHelper, IIngredientManager ingredientManager) {
        this.internal = internal;
        this.modIdHelper = modIdHelper;
        this.ingredientManager = ingredientManager;
    }

    @Override
    public <V> IFocus<V> createFocus(IFocus.Mode mode, V ingredient) {
        RecipeIngredientRole role = mode.toRole();
        IIngredientType<V> ingredientType = this.ingredientManager.getIngredientType(ingredient);
        return Focus.createFromApi(this.ingredientManager, role, ingredientType, ingredient);
    }

    @Override
    @Deprecated
    public <T> void addRecipe(T recipe, ResourceLocation recipeCategoryUid) {
        ErrorUtil.checkNotNull(recipe, "recipe");
        ErrorUtil.checkNotNull(recipeCategoryUid, "recipeCategoryUid");
        ErrorUtil.assertMainThread();
        this.internal.addRecipes(List.of(recipe), recipeCategoryUid);
    }

    @Override
    @Nullable
    public IRecipeCategory<?> getRecipeCategory(ResourceLocation recipeCategoryUid, boolean includeHidden) {
        ErrorUtil.checkNotNull(recipeCategoryUid, "recipeCategoryUid");
        return this.internal.getRecipeCategoriesStream(List.of(recipeCategoryUid), FocusGroup.EMPTY, includeHidden).findFirst().orElse(null);
    }

    @Override
    public <V> List<IRecipeCategory<?>> getRecipeCategories(Collection<ResourceLocation> recipeCategoryUids, @Nullable IFocus<V> focus, boolean includeHidden) {
        ErrorUtil.checkNotNull(recipeCategoryUids, "recipeCategoryUids");
        IFocusGroup internalFocus = FocusGroup.createFromNullable(focus);
        return this.internal.getRecipeCategoriesStream(recipeCategoryUids, internalFocus, includeHidden).collect(Collectors.toList());
    }

    @Override
    public <V> List<IRecipeCategory<?>> getRecipeCategories(@Nullable IFocus<V> focus, boolean includeHidden) {
        IFocusGroup internalFocus = FocusGroup.createFromNullable(focus);
        return this.internal.getRecipeCategoriesStream(List.of(), internalFocus, includeHidden).collect(Collectors.toList());
    }

    @Override
    public List<IRecipeCategory<?>> getRecipeCategories(Collection<? extends IFocus<?>> focus, boolean includeHidden) {
        IFocusGroup internalFocus = FocusGroup.create(focus);
        return this.internal.getRecipeCategoriesStream(List.of(), internalFocus, includeHidden).collect(Collectors.toList());
    }

    @Override
    public <T, V> List<T> getRecipes(IRecipeCategory<T> recipeCategory, @Nullable IFocus<V> focus, boolean includeHidden) {
        ErrorUtil.checkNotNull(recipeCategory, "recipeCategory");
        IFocusGroup internalFocus = FocusGroup.createFromNullable(focus);
        return this.internal.getRecipesStream(recipeCategory, internalFocus, includeHidden).collect(Collectors.toList());
    }

    @Override
    public <T> List<T> getRecipes(IRecipeCategory<T> recipeCategory, List<? extends IFocus<?>> focuses, boolean includeHidden) {
        ErrorUtil.checkNotNull(recipeCategory, "recipeCategory");
        IFocusGroup internalFocus = FocusGroup.create(focuses);
        return this.internal.getRecipesStream(recipeCategory, internalFocus, includeHidden).collect(Collectors.toList());
    }

    @Override
    public List<Object> getRecipeCatalysts(IRecipeCategory<?> recipeCategory, boolean includeHidden) {
        ErrorUtil.checkNotNull(recipeCategory, "recipeCategory");
        return this.internal.getRecipeCatalystStream(recipeCategory, includeHidden).map(ITypedIngredient::getIngredient).collect(Collectors.toList());
    }

    @Override
    public List<ITypedIngredient<?>> getRecipeCatalystsTyped(IRecipeCategory<?> recipeCategory, boolean includeHidden) {
        ErrorUtil.checkNotNull(recipeCategory, "recipeCategory");
        return this.internal.getRecipeCatalystStream(recipeCategory, includeHidden).toList();
    }

    @Override
    public <T> IRecipeLayoutDrawable createRecipeLayoutDrawable(IRecipeCategory<T> recipeCategory, T recipe, @Nullable IFocus<?> focus) {
        IFocusGroup focusGroup = FocusGroup.createFromNullable(focus);
        RecipeLayout<T> recipeLayout = RecipeLayout.create(-1, recipeCategory, recipe, focusGroup, this.ingredientManager, this.modIdHelper, 0, 0);
        Preconditions.checkNotNull(recipeLayout, (Object)"Recipe layout crashed during creation, see log.");
        return recipeLayout.getLegacyAdapter();
    }

    @Override
    public <T> void hideRecipe(T recipe, ResourceLocation recipeCategoryUid) {
        ErrorUtil.checkNotNull(recipe, "recipe");
        ErrorUtil.checkNotNull(recipeCategoryUid, "recipeCategoryUid");
        ErrorUtil.assertMainThread();
        this.internal.hideRecipe(recipe, recipeCategoryUid);
    }

    @Override
    public <T> void unhideRecipe(T recipe, ResourceLocation recipeCategoryUid) {
        ErrorUtil.checkNotNull(recipe, "recipe");
        ErrorUtil.checkNotNull(recipeCategoryUid, "recipeCategoryUid");
        ErrorUtil.assertMainThread();
        this.internal.unhideRecipe(recipe, recipeCategoryUid);
    }

    @Override
    public void hideRecipeCategory(ResourceLocation recipeCategoryUid) {
        ErrorUtil.checkNotNull(recipeCategoryUid, "recipeCategoryUid");
        ErrorUtil.assertMainThread();
        this.internal.hideRecipeCategory(recipeCategoryUid);
    }

    @Override
    public void unhideRecipeCategory(ResourceLocation recipeCategoryUid) {
        ErrorUtil.checkNotNull(recipeCategoryUid, "recipeCategoryUid");
        ErrorUtil.assertMainThread();
        this.internal.unhideRecipeCategory(recipeCategoryUid);
    }
}

