/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.plugins.vanilla.anvil;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Optional;
import mezz.jei.api.constants.VanillaRecipeCategoryUid;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.config.Constants;
import mezz.jei.plugins.vanilla.anvil.AnvilRecipe;
import mezz.jei.plugins.vanilla.anvil.AnvilRecipeMaker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import org.jetbrains.annotations.Nullable;

public class AnvilRecipeCategory
implements IRecipeCategory<AnvilRecipe> {
    private final IDrawable background;
    private final IDrawable icon;
    private final String leftSlotName = "leftSlot";
    private final String rightSlotName = "rightSlot";

    public AnvilRecipeCategory(IGuiHelper guiHelper) {
        this.background = guiHelper.drawableBuilder(Constants.RECIPE_GUI_VANILLA, 0, 168, 125, 18).addPadding(0, 20, 0, 0).build();
        this.icon = guiHelper.createDrawableIngredient(VanillaTypes.ITEM, new ItemStack((ItemLike)Blocks.f_50322_));
    }

    @Override
    public ResourceLocation getUid() {
        return VanillaRecipeCategoryUid.ANVIL;
    }

    @Override
    public Class<? extends AnvilRecipe> getRecipeClass() {
        return AnvilRecipe.class;
    }

    @Override
    public Component getTitle() {
        return Blocks.f_50322_.m_49954_();
    }

    @Override
    public IDrawable getBackground() {
        return this.background;
    }

    @Override
    public IDrawable getIcon() {
        return this.icon;
    }

    @Override
    public void setRecipe(IRecipeLayoutBuilder builder, AnvilRecipe recipe, IFocusGroup focuses) {
        ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.INPUT, 1, 1).addItemStacks(recipe.getLeftInputs())).setSlotName("leftSlot");
        ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.INPUT, 50, 1).addItemStacks(recipe.getRightInputs())).setSlotName("rightSlot");
        builder.addSlot(RecipeIngredientRole.OUTPUT, 108, 1).addItemStacks(recipe.getOutputs());
    }

    @Override
    public void draw(AnvilRecipe recipe, IRecipeSlotsView recipeSlotsView, PoseStack poseStack, double mouseX, double mouseY) {
        Optional leftStack = recipeSlotsView.findSlotByName("leftSlot").flatMap(slot1 -> slot1.getDisplayedIngredient(VanillaTypes.ITEM));
        Optional rightStack = recipeSlotsView.findSlotByName("rightSlot").flatMap(slot -> slot.getDisplayedIngredient(VanillaTypes.ITEM));
        if (leftStack.isEmpty() || rightStack.isEmpty()) {
            return;
        }
        int cost = AnvilRecipeMaker.findLevelsCost((ItemStack)leftStack.get(), (ItemStack)rightStack.get());
        String costText = cost < 0 ? "err" : Integer.toString(cost);
        String text = I18n.m_118938_((String)"container.repair.cost", (Object[])new Object[]{costText});
        Minecraft minecraft = Minecraft.m_91087_();
        LocalPlayer player = minecraft.f_91074_;
        int mainColor = AnvilRecipeCategory.playerHasEnoughLevels(player, cost) ? -8323296 : -40864;
        this.drawRepairCost(minecraft, poseStack, text, mainColor);
    }

    private static boolean playerHasEnoughLevels(@Nullable LocalPlayer player, int cost) {
        if (player == null) {
            return true;
        }
        if (player.m_7500_()) {
            return true;
        }
        return cost < 40 && cost <= player.f_36078_;
    }

    private void drawRepairCost(Minecraft minecraft, PoseStack poseStack, String text, int mainColor) {
        int shadowColor = 0xFF000000 | (mainColor & 0xFCFCFC) >> 2;
        int width = minecraft.f_91062_.m_92895_(text);
        int x = this.background.getWidth() - 2 - width;
        int y = 27;
        minecraft.f_91062_.m_92883_(poseStack, text, (float)(x + 1), (float)y, shadowColor);
        minecraft.f_91062_.m_92883_(poseStack, text, (float)x, (float)(y + 1), shadowColor);
        minecraft.f_91062_.m_92883_(poseStack, text, (float)(x + 1), (float)(y + 1), shadowColor);
        minecraft.f_91062_.m_92883_(poseStack, text, (float)x, (float)y, mainColor);
    }
}

