/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.ingredients;

import com.google.common.base.Preconditions;
import java.util.Optional;
import mezz.jei.api.ingredients.IIngredientHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.ingredients.ITypedIngredient;
import mezz.jei.api.runtime.IIngredientManager;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public final class TypedIngredient<T>
implements ITypedIngredient<T> {
    private final IIngredientType<T> ingredientType;
    private final T ingredient;

    private static <T> void assertIsValidIngredient(IIngredientManager ingredientManager, IIngredientType<T> ingredientType, T ingredient) {
        boolean valid;
        Preconditions.checkNotNull(ingredientType, (Object)"ingredientType");
        Preconditions.checkNotNull(ingredient, (Object)"ingredient");
        Class<T> ingredientClass = ingredientType.getIngredientClass();
        if (!ingredientClass.isInstance(ingredient)) {
            throw new IllegalArgumentException("Invalid ingredient found.  Should be an instance of: " + ingredientClass + " Instead got: " + ingredient.getClass());
        }
        IIngredientHelper<T> ingredientHelper = ingredientManager.getIngredientHelper(ingredientType);
        try {
            valid = ingredientHelper.isValidIngredient(ingredient);
        }
        catch (RuntimeException e) {
            String ingredientInfo = ingredientHelper.getErrorInfo(ingredient);
            throw new IllegalArgumentException("Invalid ingredient found. Ingredient Info: " + ingredientInfo, e);
        }
        if (!valid) {
            String ingredientInfo = ingredientHelper.getErrorInfo(ingredient);
            throw new IllegalArgumentException("Invalid ingredient found. Ingredient Info: " + ingredientInfo);
        }
    }

    public static <T> Optional<ITypedIngredient<?>> create(IIngredientManager ingredientManager, @Nullable T ingredient) {
        if (TypedIngredient.isBlankIngredient(ingredient)) {
            return Optional.empty();
        }
        IIngredientType<T> ingredientType = ingredientManager.getIngredientType(ingredient);
        TypedIngredient.assertIsValidIngredient(ingredientManager, ingredientType, ingredient);
        TypedIngredient<T> typedIngredient = new TypedIngredient<T>(ingredientType, ingredient);
        return Optional.of(typedIngredient);
    }

    public static <T> Optional<ITypedIngredient<?>> create(IIngredientManager ingredientManager, IIngredientType<T> ingredientType, @Nullable T ingredient) {
        if (TypedIngredient.isBlankIngredient(ingredient)) {
            return Optional.empty();
        }
        TypedIngredient.assertIsValidIngredient(ingredientManager, ingredientType, ingredient);
        TypedIngredient<T> typedIngredient = new TypedIngredient<T>(ingredientType, ingredient);
        return Optional.of(typedIngredient);
    }

    public static <T> Optional<ITypedIngredient<T>> createTyped(IIngredientManager ingredientManager, IIngredientType<T> ingredientType, @Nullable T ingredient) {
        if (TypedIngredient.isBlankIngredient(ingredient)) {
            return Optional.empty();
        }
        TypedIngredient.assertIsValidIngredient(ingredientManager, ingredientType, ingredient);
        TypedIngredient<T> typedIngredient = new TypedIngredient<T>(ingredientType, ingredient);
        return Optional.of(typedIngredient);
    }

    public static <T> Optional<ITypedIngredient<T>> normalize(IIngredientManager ingredientManager, ITypedIngredient<T> value) {
        IIngredientHelper<T> ingredientHelper = ingredientManager.getIngredientHelper(value.getType());
        T ingredient = ingredientHelper.normalizeIngredient(value.getIngredient());
        return TypedIngredient.createTyped(ingredientManager, value.getType(), ingredient);
    }

    public static <T> Optional<ITypedIngredient<T>> deepCopy(IIngredientManager ingredientManager, ITypedIngredient<T> value) {
        IIngredientHelper<T> ingredientHelper = ingredientManager.getIngredientHelper(value.getType());
        T ingredient = ingredientHelper.copyIngredient(value.getIngredient());
        return TypedIngredient.createTyped(ingredientManager, value.getType(), ingredient);
    }

    private TypedIngredient(IIngredientType<T> ingredientType, T ingredient) {
        this.ingredientType = ingredientType;
        this.ingredient = ingredient;
    }

    @Override
    public <V> Optional<V> getIngredient(IIngredientType<V> ingredientType) {
        if (this.ingredientType == ingredientType) {
            T castIngredient = this.ingredient;
            return Optional.of(castIngredient);
        }
        return Optional.empty();
    }

    @Override
    public T getIngredient() {
        return this.ingredient;
    }

    @Override
    public IIngredientType<T> getType() {
        return this.ingredientType;
    }

    private static boolean isBlankIngredient(@Nullable Object ingredient) {
        ItemStack itemStack;
        return ingredient == null || ingredient instanceof ItemStack && (itemStack = (ItemStack)ingredient).m_41619_();
    }
}

