/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.gui.recipes.builder;

import it.unimi.dsi.fastutil.ints.IntArraySet;
import it.unimi.dsi.fastutil.ints.IntCollection;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.IntSummaryStatistics;
import java.util.List;
import java.util.stream.Stream;
import mezz.jei.api.gui.builder.IIngredientAcceptor;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.runtime.IIngredientManager;
import mezz.jei.gui.recipes.RecipeLayout;
import mezz.jei.gui.recipes.builder.IRecipeLayoutSlotSource;
import mezz.jei.gui.recipes.builder.InvisibleRecipeLayoutSlotSource;
import mezz.jei.gui.recipes.builder.RecipeSlotBuilder;
import mezz.jei.ingredients.IIngredientSupplier;

public class RecipeLayoutBuilder
implements IRecipeLayoutBuilder,
IIngredientSupplier {
    private final List<IRecipeLayoutSlotSource> slots = new ArrayList<IRecipeLayoutSlotSource>();
    private final List<List<IRecipeLayoutSlotSource>> focusLinkedSlots = new ArrayList<List<IRecipeLayoutSlotSource>>();
    private final IIngredientManager ingredientManager;
    private final int ingredientCycleOffset;
    private boolean shapeless = false;
    private int recipeTransferX = -1;
    private int recipeTransferY = -1;
    private int shapelessX = -1;
    private int shapelessY = -1;
    private int legacyIngredientIndex = 0;

    public RecipeLayoutBuilder(IIngredientManager ingredientManager, int ingredientCycleOffset) {
        this.ingredientManager = ingredientManager;
        this.ingredientCycleOffset = ingredientCycleOffset;
    }

    @Override
    public IRecipeSlotBuilder addSlot(RecipeIngredientRole role, int x, int y) {
        RecipeSlotBuilder slotBuilder = new RecipeSlotBuilder(this.ingredientManager, role, x, y, this.ingredientCycleOffset, this.legacyIngredientIndex++);
        this.slots.add(slotBuilder);
        return slotBuilder;
    }

    @Override
    public IIngredientAcceptor<?> addInvisibleIngredients(RecipeIngredientRole role) {
        InvisibleRecipeLayoutSlotSource slot = new InvisibleRecipeLayoutSlotSource(this.ingredientManager, role);
        this.slots.add(slot);
        return slot;
    }

    @Override
    public void moveRecipeTransferButton(int posX, int posY) {
        this.recipeTransferX = posX;
        this.recipeTransferY = posY;
    }

    @Override
    public void setShapeless() {
        this.shapeless = true;
    }

    @Override
    public void setShapeless(int posX, int posY) {
        this.shapeless = true;
        this.shapelessX = posX;
        this.shapelessY = posY;
    }

    @Override
    public void createFocusLink(IRecipeSlotBuilder ... slots) {
        List<IRecipeLayoutSlotSource> builders = Arrays.stream(slots).map(IRecipeLayoutSlotSource.class::cast).toList();
        IntSummaryStatistics stats = builders.stream().mapToInt(IRecipeLayoutSlotSource::getIngredientCount).summaryStatistics();
        if (stats.getMin() != stats.getMax()) {
            throw new IllegalArgumentException("All slots must have the same number of ingredients in order to create a focus link. " + String.format("slot stats: %s", stats));
        }
        this.slots.removeAll(builders);
        this.focusLinkedSlots.add(builders);
    }

    public boolean isUsed() {
        return !this.slots.isEmpty() || !this.focusLinkedSlots.isEmpty();
    }

    public <R> void setRecipeLayout(RecipeLayout<R> recipeLayout, IFocusGroup focuses) {
        IntSet focusMatches;
        if (this.shapeless) {
            if (this.shapelessX >= 0 && this.shapelessY >= 0) {
                recipeLayout.setShapeless(this.shapelessX, this.shapelessY);
            } else {
                recipeLayout.setShapeless();
            }
        }
        if (this.recipeTransferX >= 0 && this.recipeTransferY >= 0) {
            recipeLayout.moveRecipeTransferButton(this.recipeTransferX, this.recipeTransferY);
        }
        for (IRecipeLayoutSlotSource iRecipeLayoutSlotSource : this.slots) {
            focusMatches = iRecipeLayoutSlotSource.getMatches(focuses);
            iRecipeLayoutSlotSource.setRecipeLayout(recipeLayout, focusMatches);
        }
        for (List list : this.focusLinkedSlots) {
            focusMatches = new IntArraySet();
            for (IRecipeLayoutSlotSource slot : list) {
                focusMatches.addAll((IntCollection)slot.getMatches(focuses));
            }
            for (IRecipeLayoutSlotSource slot : list) {
                slot.setRecipeLayout(recipeLayout, focusMatches);
            }
        }
    }

    private Stream<IRecipeLayoutSlotSource> slotStream() {
        return Stream.concat(this.slots.stream(), this.focusLinkedSlots.stream().flatMap(Collection::stream));
    }

    @Override
    public Stream<? extends IIngredientType<?>> getIngredientTypes(RecipeIngredientRole role) {
        return this.slotStream().filter(slot -> slot.getRole() == role).flatMap(IRecipeLayoutSlotSource::getIngredientTypes).distinct();
    }

    @Override
    public <T> Stream<T> getIngredientStream(IIngredientType<T> ingredientType, RecipeIngredientRole role) {
        return this.slotStream().filter(slot -> slot.getRole() == role).flatMap(slot -> slot.getIngredients(ingredientType));
    }
}

