/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.gui.recipes;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Collections;
import java.util.List;
import mezz.jei.Internal;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.gui.HoverChecker;
import mezz.jei.gui.elements.HighResolutionDrawable;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import org.jetbrains.annotations.Nullable;

public class ShapelessIcon {
    private final HighResolutionDrawable icon = Internal.getTextures().getShapelessIcon();
    private final HoverChecker hoverChecker = new HoverChecker();
    private int posX;
    private int posY;

    public ShapelessIcon() {
        this.setPosition(0, 0);
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setPosition(int posX, int posY) {
        this.posX = posX;
        this.posY = posY;
        Rect2i area = new Rect2i(posX, posY, this.icon.getWidth(), this.icon.getHeight());
        this.hoverChecker.updateBounds(area);
    }

    public void draw(PoseStack poseStack) {
        this.icon.draw(poseStack, this.posX, this.posY);
    }

    @Nullable
    public List<Component> getTooltipStrings(int mouseX, int mouseY) {
        if (this.hoverChecker.checkHover(mouseX, mouseY)) {
            return Collections.singletonList(new TranslatableComponent("jei.tooltip.shapeless.recipe"));
        }
        return null;
    }
}

