/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.gui.recipes;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import java.util.Optional;
import mezz.jei.Internal;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.helpers.IModIdHelper;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.runtime.IIngredientManager;
import mezz.jei.gui.TooltipRenderer;
import mezz.jei.gui.elements.DrawableNineSliceTexture;
import mezz.jei.gui.ingredients.RecipeSlot;
import mezz.jei.gui.ingredients.RecipeSlots;
import mezz.jei.gui.recipes.OutputSlotTooltipCallback;
import mezz.jei.gui.recipes.RecipeLayoutLegacyAdapter;
import mezz.jei.gui.recipes.RecipeTransferButton;
import mezz.jei.gui.recipes.ShapelessIcon;
import mezz.jei.gui.recipes.builder.RecipeLayoutBuilder;
import mezz.jei.input.UserInput;
import mezz.jei.util.ErrorUtil;
import mezz.jei.util.MathUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public class RecipeLayout<R> {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final int HIGHLIGHT_COLOR = Integer.MAX_VALUE;
    private static final int RECIPE_BORDER_PADDING = 4;
    private final int ingredientCycleOffset = (int)(Math.random() * 10000.0 % 2.147483647E9);
    private final IRecipeCategory<R> recipeCategory;
    private final IIngredientManager ingredientManager;
    private final RecipeSlots recipeSlots;
    private final RecipeLayoutLegacyAdapter<R> legacyAdapter;
    private final R recipe;
    private final DrawableNineSliceTexture recipeBorder;
    @Nullable
    private final RecipeTransferButton recipeTransferButton;
    @Nullable
    private ShapelessIcon shapelessIcon;
    private int posX;
    private int posY;

    @Nullable
    public static <T> RecipeLayout<T> create(int index, IRecipeCategory<T> recipeCategory, T recipe, IFocusGroup focuses, IIngredientManager ingredientManager, IModIdHelper modIdHelper, int posX, int posY) {
        RecipeLayout<T> recipeLayout = new RecipeLayout<T>(index, recipeCategory, recipe, focuses, ingredientManager, posX, posY);
        if (recipeLayout.setRecipeLayout(recipeCategory, recipe, ingredientManager, focuses) || recipeLayout.getLegacyAdapter().setRecipeLayout(recipeCategory, recipe)) {
            ResourceLocation recipeName = recipeCategory.getRegistryName(recipe);
            if (recipeName != null) {
                RecipeLayout.addOutputSlotTooltip(recipeLayout, recipeName, modIdHelper);
            }
            return recipeLayout;
        }
        return null;
    }

    private boolean setRecipeLayout(IRecipeCategory<R> recipeCategory, R recipe, IIngredientManager ingredientManager, IFocusGroup focuses) {
        RecipeLayoutBuilder builder = new RecipeLayoutBuilder(ingredientManager, this.ingredientCycleOffset);
        try {
            recipeCategory.setRecipe((IRecipeLayoutBuilder)builder, recipe, focuses);
            if (builder.isUsed()) {
                builder.setRecipeLayout(this, focuses);
                return true;
            }
        }
        catch (LinkageError | RuntimeException e) {
            LOGGER.error("Error caught from Recipe Category: {}", (Object)recipeCategory.getUid(), (Object)e);
        }
        return false;
    }

    private static void addOutputSlotTooltip(RecipeLayout<?> recipeLayout, ResourceLocation recipeName, IModIdHelper modIdHelper) {
        RecipeSlots recipeSlots = recipeLayout.recipeSlots;
        List<RecipeSlot> outputSlots = recipeSlots.getSlots().stream().filter(r -> r.getRole() == RecipeIngredientRole.OUTPUT).toList();
        if (!outputSlots.isEmpty()) {
            OutputSlotTooltipCallback callback = new OutputSlotTooltipCallback(recipeName, modIdHelper, recipeLayout.ingredientManager);
            for (RecipeSlot outputSlot : outputSlots) {
                outputSlot.addTooltipCallback(callback);
            }
        }
    }

    public RecipeLayout(int index, IRecipeCategory<R> recipeCategory, R recipe, IFocusGroup focuses, IIngredientManager ingredientManager, int posX, int posY) {
        ErrorUtil.checkNotNull(recipeCategory, "recipeCategory");
        ErrorUtil.checkNotNull(recipe, "recipe");
        ErrorUtil.checkNotNull(ingredientManager, "ingredientManager");
        ErrorUtil.checkNotNull(focuses, "focuses");
        this.recipeCategory = recipeCategory;
        this.ingredientManager = ingredientManager;
        this.recipeSlots = new RecipeSlots();
        if (index >= 0) {
            IDrawableStatic icon = Internal.getTextures().getRecipeTransfer();
            IDrawable background = recipeCategory.getBackground();
            int width = background.getWidth();
            int height = background.getHeight();
            int buttonX = width + 4 + 2;
            int buttonY = height - 13;
            this.recipeTransferButton = new RecipeTransferButton(buttonX, buttonY, icon, this);
        } else {
            this.recipeTransferButton = null;
        }
        this.setPosition(posX, posY);
        this.recipe = recipe;
        this.recipeBorder = Internal.getTextures().getRecipeBackground();
        this.legacyAdapter = new RecipeLayoutLegacyAdapter(this, ingredientManager, focuses, this.ingredientCycleOffset);
    }

    public void setPosition(int posX, int posY) {
        if (this.recipeTransferButton != null) {
            int xDiff = posX - this.posX;
            int yDiff = posY - this.posY;
            this.recipeTransferButton.f_93620_ += xDiff;
            this.recipeTransferButton.f_93621_ += yDiff;
        }
        this.posX = posX;
        this.posY = posY;
    }

    public void drawRecipe(PoseStack poseStack, int mouseX, int mouseY) {
        IDrawable background = this.recipeCategory.getBackground();
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int recipeMouseX = mouseX - this.posX;
        int recipeMouseY = mouseY - this.posY;
        poseStack.m_85836_();
        poseStack.m_85837_((double)this.posX, (double)this.posY, 0.0);
        IDrawable categoryBackground = this.recipeCategory.getBackground();
        int width = categoryBackground.getWidth() + 8;
        int height = categoryBackground.getHeight() + 8;
        this.recipeBorder.draw(poseStack, -4, -4, width, height);
        background.draw(poseStack);
        poseStack.m_85836_();
        this.recipeCategory.draw(this.recipe, this.recipeSlots.getView(), poseStack, recipeMouseX, recipeMouseY);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        poseStack.m_85849_();
        if (this.shapelessIcon != null) {
            this.shapelessIcon.draw(poseStack);
        }
        this.recipeSlots.draw(poseStack, Integer.MAX_VALUE, mouseX, mouseY);
        poseStack.m_85849_();
        if (this.recipeTransferButton != null) {
            Minecraft minecraft = Minecraft.m_91087_();
            float partialTicks = minecraft.m_91296_();
            this.recipeTransferButton.m_6305_(poseStack, mouseX, mouseY, partialTicks);
        }
        RenderSystem.m_69461_();
    }

    public void drawOverlays(PoseStack poseStack, int mouseX, int mouseY) {
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int recipeMouseX = mouseX - this.posX;
        int recipeMouseY = mouseY - this.posY;
        RecipeSlot hoveredSlot = this.recipeSlots.getHoveredSlot(recipeMouseX, recipeMouseY).orElse(null);
        if (this.recipeTransferButton != null) {
            this.recipeTransferButton.drawToolTip(poseStack, mouseX, mouseY);
        }
        RenderSystem.m_69461_();
        if (hoveredSlot != null) {
            hoveredSlot.drawOverlays(poseStack, this.posX, this.posY, recipeMouseX, recipeMouseY);
        } else if (this.isMouseOver(mouseX, mouseY)) {
            List<Component> tooltipStrings = this.recipeCategory.getTooltipStrings(this.recipe, this.recipeSlots.getView(), recipeMouseX, recipeMouseY);
            if (tooltipStrings.isEmpty() && this.shapelessIcon != null) {
                tooltipStrings = this.shapelessIcon.getTooltipStrings(recipeMouseX, recipeMouseY);
            }
            if (tooltipStrings != null && !tooltipStrings.isEmpty()) {
                TooltipRenderer.drawHoveringText(poseStack, tooltipStrings, mouseX, mouseY);
            }
        }
    }

    public boolean isMouseOver(double mouseX, double mouseY) {
        IDrawable background = this.recipeCategory.getBackground();
        Rect2i backgroundRect = new Rect2i(this.posX, this.posY, background.getWidth(), background.getHeight());
        return MathUtil.contains(backgroundRect, mouseX, mouseY) || this.recipeTransferButton != null && this.recipeTransferButton.m_5953_(mouseX, mouseY);
    }

    public Optional<RecipeSlot> getRecipeSlotUnderMouse(double mouseX, double mouseY) {
        double recipeMouseX = mouseX - (double)this.posX;
        double recipeMouseY = mouseY - (double)this.posY;
        return this.recipeSlots.getHoveredSlot(recipeMouseX, recipeMouseY);
    }

    public boolean handleInput(UserInput input) {
        return this.recipeCategory.handleInput(this.recipe, input.getMouseX() - (double)this.posX, input.getMouseY() - (double)this.posY, input.getKey());
    }

    public void moveRecipeTransferButton(int posX, int posY) {
        if (this.recipeTransferButton != null) {
            this.recipeTransferButton.f_93620_ = posX + this.posX;
            this.recipeTransferButton.f_93621_ = posY + this.posY;
        }
    }

    public void setShapeless() {
        this.shapelessIcon = new ShapelessIcon();
        int categoryWidth = this.recipeCategory.getBackground().getWidth();
        int x = categoryWidth - this.shapelessIcon.getIcon().getWidth();
        int y = 0;
        this.shapelessIcon.setPosition(x, y);
    }

    public void setShapeless(int shapelessX, int shapelessY) {
        this.shapelessIcon = new ShapelessIcon();
        this.shapelessIcon.setPosition(shapelessX, shapelessY);
    }

    @Nullable
    public RecipeTransferButton getRecipeTransferButton() {
        return this.recipeTransferButton;
    }

    public IRecipeCategory<R> getRecipeCategory() {
        return this.recipeCategory;
    }

    public int getPosX() {
        return this.posX;
    }

    public int getPosY() {
        return this.posY;
    }

    public R getRecipe() {
        return this.recipe;
    }

    public RecipeSlots getRecipeSlots() {
        return this.recipeSlots;
    }

    public RecipeLayoutLegacyAdapter<R> getLegacyAdapter() {
        return this.legacyAdapter;
    }
}

