/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.gui.overlay;

import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.List;
import mezz.jei.api.ingredients.ITypedIngredient;
import mezz.jei.gui.overlay.IIngredientGridSource;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class WeakIngredientGridSource
implements IIngredientGridSource {
    private static final Logger LOGGER = LogManager.getLogger();
    private final WeakReference<IIngredientGridSource> weakIngredientSource;

    public WeakIngredientGridSource(IIngredientGridSource source) {
        this.weakIngredientSource = new WeakReference<IIngredientGridSource>(source);
    }

    @Override
    public List<ITypedIngredient<?>> getIngredientList(String filterText) {
        IIngredientGridSource ingredientGridSource = (IIngredientGridSource)this.weakIngredientSource.get();
        if (ingredientGridSource == null) {
            LOGGER.error("no ingredientGridSource");
            return Collections.emptyList();
        }
        return ingredientGridSource.getIngredientList(filterText);
    }

    @Override
    public void addListener(IIngredientGridSource.Listener listener) {
        IIngredientGridSource ingredientGridSource = (IIngredientGridSource)this.weakIngredientSource.get();
        if (ingredientGridSource == null) {
            LOGGER.error("no ingredientGridSource");
            return;
        }
        ingredientGridSource.addListener(listener);
    }
}

