/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.gui.overlay;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import mezz.jei.api.gui.handlers.IGuiProperties;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.ingredients.ITypedIngredient;
import mezz.jei.api.runtime.IIngredientListOverlay;
import mezz.jei.config.IClientConfig;
import mezz.jei.config.IWorldConfig;
import mezz.jei.gui.GuiScreenHelper;
import mezz.jei.gui.elements.GuiIconToggleButton;
import mezz.jei.gui.ghost.GhostIngredientDragManager;
import mezz.jei.gui.overlay.ConfigButton;
import mezz.jei.gui.overlay.GuiProperties;
import mezz.jei.gui.overlay.IIngredientGridSource;
import mezz.jei.gui.overlay.IngredientGridWithNavigation;
import mezz.jei.ingredients.IngredientManager;
import mezz.jei.input.GuiTextFieldFilter;
import mezz.jei.input.IClickedIngredient;
import mezz.jei.input.IRecipeFocusSource;
import mezz.jei.input.MouseUtil;
import mezz.jei.input.mouse.ICharTypedHandler;
import mezz.jei.input.mouse.IUserInputHandler;
import mezz.jei.input.mouse.handlers.CheatInputHandler;
import mezz.jei.input.mouse.handlers.CombinedInputHandler;
import mezz.jei.input.mouse.handlers.NullInputHandler;
import mezz.jei.input.mouse.handlers.ProxyInputHandler;
import mezz.jei.util.MathUtil;
import mezz.jei.util.Rectangle2dBuilder;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.util.Tuple;
import org.jetbrains.annotations.Nullable;

public class IngredientListOverlay
implements IIngredientListOverlay,
IRecipeFocusSource,
ICharTypedHandler {
    private static final int BORDER_PADDING = 2;
    private static final int BUTTON_SIZE = 20;
    private static final int SEARCH_HEIGHT = 20;
    private final GuiIconToggleButton configButton;
    private final IngredientGridWithNavigation contents;
    private final IClientConfig clientConfig;
    private final IWorldConfig worldConfig;
    private final GuiScreenHelper guiScreenHelper;
    private final GuiTextFieldFilter searchField;
    private final GhostIngredientDragManager ghostIngredientDragManager;
    private Rect2i displayArea = new Rect2i(0, 0, 0, 0);
    private boolean hasRoom;
    @Nullable
    private IGuiProperties guiProperties;

    public IngredientListOverlay(IIngredientGridSource ingredientGridSource, IngredientManager ingredientManager, GuiScreenHelper guiScreenHelper, IngredientGridWithNavigation contents, IClientConfig clientConfig, IWorldConfig worldConfig) {
        this.guiScreenHelper = guiScreenHelper;
        this.contents = contents;
        this.clientConfig = clientConfig;
        this.worldConfig = worldConfig;
        ingredientGridSource.addListener(() -> this.onSetFilterText(worldConfig.getFilterText()));
        this.searchField = new GuiTextFieldFilter(ingredientGridSource);
        this.searchField.m_94151_(text -> {
            if (this.worldConfig.setFilterText((String)text)) {
                this.updateLayout(true);
            }
        });
        this.configButton = ConfigButton.create(this, worldConfig);
        this.ghostIngredientDragManager = new GhostIngredientDragManager(this.contents, guiScreenHelper, ingredientManager, worldConfig);
        this.searchField.m_93692_(false);
    }

    public boolean isListDisplayed() {
        return this.worldConfig.isOverlayEnabled() && this.guiProperties != null && this.hasRoom;
    }

    private static Rect2i createDisplayArea(IGuiProperties guiProperties) {
        Rect2i screenRectangle = GuiProperties.getScreenRectangle(guiProperties);
        int guiRight = GuiProperties.getGuiRight(guiProperties);
        Tuple<Rect2i, Rect2i> result = MathUtil.splitX(screenRectangle, guiRight);
        Rect2i displayArea = (Rect2i)result.m_14419_();
        return new Rectangle2dBuilder(displayArea).insetByPadding(2).build();
    }

    public void updateScreen(@Nullable Screen guiScreen, boolean exclusionAreasChanged) {
        boolean wasDisplayed = this.isListDisplayed();
        IGuiProperties guiProperties = this.guiScreenHelper.getGuiProperties(guiScreen);
        if (guiProperties == null) {
            if (this.guiProperties != null) {
                this.guiProperties = null;
                this.searchField.m_93692_(false);
                this.ghostIngredientDragManager.stopDrag();
            }
        } else {
            boolean guiPropertiesChanged;
            boolean bl = guiPropertiesChanged = this.guiProperties == null || !GuiProperties.areEqual(this.guiProperties, guiProperties);
            if (exclusionAreasChanged || guiPropertiesChanged) {
                this.updateNewScreen(guiProperties, guiPropertiesChanged);
            }
        }
        if (wasDisplayed && !this.isListDisplayed()) {
            this.worldConfig.saveFilterText();
        }
    }

    private void updateNewScreen(IGuiProperties guiProperties, boolean guiPropertiesChanged) {
        this.guiProperties = guiProperties;
        this.displayArea = IngredientListOverlay.createDisplayArea(guiProperties);
        if (guiPropertiesChanged) {
            this.ghostIngredientDragManager.stopDrag();
        }
        boolean searchBarCentered = IngredientListOverlay.isSearchBarCentered(this.clientConfig, guiProperties);
        Set<Rect2i> guiExclusionAreas = this.guiScreenHelper.getGuiExclusionAreas();
        Rect2i availableContentsArea = new Rectangle2dBuilder(this.displayArea).subtractHeight(searchBarCentered ? 0 : 22).build();
        this.hasRoom = this.contents.updateBounds(availableContentsArea, guiExclusionAreas);
        Rect2i contentsArea = this.contents.getArea();
        this.displayArea = new Rectangle2dBuilder(this.displayArea).setX(contentsArea).setWidth(contentsArea).build();
        Tuple<Rect2i, Rect2i> result = IngredientListOverlay.getSearchAndConfigArea(searchBarCentered, guiProperties, this.displayArea);
        Rect2i searchAndConfigArea = (Rect2i)result.m_14419_();
        result = MathUtil.splitXRight(searchAndConfigArea, 20);
        Rect2i searchArea = (Rect2i)result.m_14418_();
        Rect2i configButtonArea = (Rect2i)result.m_14419_();
        this.searchField.updateBounds(searchArea);
        this.configButton.updateBounds(configButtonArea);
        this.updateLayout(false);
    }

    private static boolean isSearchBarCentered(IClientConfig clientConfig, IGuiProperties guiProperties) {
        return clientConfig.isCenterSearchBarEnabled() && GuiProperties.getGuiBottom(guiProperties) + 20 < guiProperties.getScreenHeight();
    }

    private static Tuple<Rect2i, Rect2i> getSearchAndConfigArea(boolean searchBarCentered, IGuiProperties guiProperties, Rect2i displayArea) {
        if (searchBarCentered) {
            Rect2i guiRectangle = GuiProperties.getGuiRectangle(guiProperties);
            Rect2i searchRect = new Rect2i(guiRectangle.m_110085_(), displayArea.m_110091_() - 20, guiRectangle.m_110090_(), 20);
            return new Tuple((Object)displayArea, (Object)searchRect);
        }
        return MathUtil.splitYBottom(displayArea, 20);
    }

    public void updateLayout(boolean filterChanged) {
        this.contents.updateLayout(filterChanged);
        this.searchField.m_94144_(this.worldConfig.getFilterText());
    }

    public void drawScreen(Minecraft minecraft, PoseStack poseStack, int mouseX, int mouseY, float partialTicks) {
        if (this.isListDisplayed()) {
            this.searchField.m_6303_(poseStack, mouseX, mouseY, partialTicks);
            this.contents.draw(minecraft, poseStack, mouseX, mouseY, partialTicks);
        }
        if (this.guiProperties != null) {
            this.configButton.draw(poseStack, mouseX, mouseY, partialTicks);
        }
    }

    public void drawTooltips(Minecraft minecraft, PoseStack poseStack, int mouseX, int mouseY) {
        if (this.isListDisplayed()) {
            this.ghostIngredientDragManager.drawTooltips(minecraft, poseStack, mouseX, mouseY);
            this.contents.drawTooltips(minecraft, poseStack, mouseX, mouseY);
        }
        if (this.guiProperties != null) {
            this.configButton.drawTooltips(poseStack, mouseX, mouseY);
        }
    }

    public void drawOnForeground(Minecraft minecraft, PoseStack poseStack, AbstractContainerScreen<?> gui, int mouseX, int mouseY) {
        if (this.isListDisplayed()) {
            poseStack.m_85836_();
            poseStack.m_85837_((double)(-gui.getGuiLeft()), (double)(-gui.getGuiTop()), 0.0);
            this.ghostIngredientDragManager.drawOnForeground(minecraft, poseStack, mouseX, mouseY);
            poseStack.m_85849_();
        }
    }

    public void handleTick() {
        if (this.isListDisplayed()) {
            this.searchField.m_94120_();
        }
    }

    public boolean isMouseOver(double mouseX, double mouseY) {
        if (this.isListDisplayed()) {
            if (this.clientConfig.isCenterSearchBarEnabled() && this.searchField.m_5953_(mouseX, mouseY)) {
                return true;
            }
            return MathUtil.contains(this.displayArea, mouseX, mouseY) && !this.guiScreenHelper.isInGuiExclusionArea(mouseX, mouseY);
        }
        if (this.guiProperties != null) {
            return this.configButton.isMouseOver(mouseX, mouseY);
        }
        return false;
    }

    @Override
    public Optional<IClickedIngredient<?>> getIngredientUnderMouse(double mouseX, double mouseY) {
        if (this.isListDisplayed()) {
            return this.contents.getIngredientUnderMouse(mouseX, mouseY);
        }
        return Optional.empty();
    }

    public IUserInputHandler createInputHandler() {
        CombinedInputHandler displayedInputHandler = new CombinedInputHandler(this.ghostIngredientDragManager.createInputHandler(), this.searchField.createInputHandler(), this.configButton.createInputHandler(), this.contents.createInputHandler(), new CheatInputHandler(this.contents, this.worldConfig, this.clientConfig));
        IUserInputHandler hiddenInputHandler = this.configButton.createInputHandler();
        return new ProxyInputHandler(() -> {
            if (this.guiProperties == null) {
                return NullInputHandler.INSTANCE;
            }
            if (this.isListDisplayed()) {
                return displayedInputHandler;
            }
            return hiddenInputHandler;
        });
    }

    @Override
    public boolean hasKeyboardFocus() {
        return this.isListDisplayed() && this.searchField.m_93696_();
    }

    @Override
    public boolean onCharTyped(char codePoint, int modifiers) {
        return this.searchField.m_5534_(codePoint, modifiers);
    }

    @Override
    public Optional<ITypedIngredient<?>> getIngredientUnderMouse() {
        if (this.isListDisplayed()) {
            return this.contents.getIngredientUnderMouse(MouseUtil.getX(), MouseUtil.getY()).map(IClickedIngredient::getValue);
        }
        return Optional.empty();
    }

    @Override
    @Nullable
    public <T> T getIngredientUnderMouse(IIngredientType<T> ingredientType) {
        if (this.isListDisplayed()) {
            return this.contents.getIngredientUnderMouse(ingredientType).map(ITypedIngredient::getIngredient).orElse(null);
        }
        return null;
    }

    public void onSetFilterText(String filterText) {
        this.searchField.m_94144_(filterText);
        this.updateLayout(true);
    }

    @Override
    public <T> List<T> getVisibleIngredients(IIngredientType<T> ingredientType) {
        if (this.isListDisplayed()) {
            return this.contents.getVisibleIngredients(ingredientType).map(ITypedIngredient::getIngredient).toList();
        }
        return Collections.emptyList();
    }
}

